/*
 * DeploymentXMLLoader.java
 *
 * Created on April 7, 2008, 3:17 PM
 */

package sidnet.models.deployment.models.xml;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import jist.runtime.JistAPI;
import sidnet.core.misc.XMLUtils;
import jist.swans.field.Placement; 
import sidnet.models.deployment.manager.DeploymentManager;

/**
 *
 * @author  Oliver
 */
@SuppressWarnings("serial")
public class DeploymentXMLLoader 
extends javax.swing.JFrame 
implements JistAPI.DoNotRewrite
{
    // DEBUG
    private static final boolean DEBUG = false;
    
    private String filename = null;
    private Boolean compatibilityPassed = false; 
    private DeploymentManager callbackManager = null;
    private int fieldLength;
    private int fieldWidth;
  
    private final static String SIDNETDIR = System.getenv("SIDNETDIR");

    /** Creates new form DeploymentXMLLoader */
    public DeploymentXMLLoader(DeploymentManager callbackManager, int fieldLength, int fieldWidth) {
        initComponents();
        this.fieldLength = fieldLength;
        this.fieldWidth = fieldWidth;
        
        this.callbackManager = callbackManager;                        
    }
    
    public void browse() {
    	if(SIDNETDIR != null) {
            if (DEBUG) System.out.println("[DEBUG][DeploymentXMLLoader()] - set current directory to SIDNETDIR = " + SIDNETDIR);
            jFileChooser1.setCurrentDirectory(new File(SIDNETDIR));
        }
        else
            if (DEBUG) System.out.println("[DEBUG][DeploymentXMLLoader()] - set current directory to default. SIDNETDIR not initialized (null) ");

    	jFileChooser1.setFileFilter(new XMLFileFilter());
        jFileChooser1.showOpenDialog(null);  
    }
    
    public void browse(String xmlFilePath) {
    	processXMLFile(new File(xmlFilePath));
    }
    
    class XMLFileFilter extends FileFilter {
        public boolean accept(File filename) {
            if (filename.isDirectory() || filename.getName().endsWith(".xml"))
                return true;
            return false;
        }

        public String getDescription() {
            return "*.xml";
        }
    }
    
    /** 
     * For testing only
     * @return
     */
    public javax.swing.JFileChooser getFileChooser() {
        return jFileChooser1;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents()
    {
        jFileChooser1 = new javax.swing.JFileChooser();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        jFileChooser1.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                jFileChooser1ActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jFileChooser1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jFileChooser1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jFileChooser1ActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jFileChooser1ActionPerformed
    {//GEN-HEADEREND:event_jFileChooser1ActionPerformed
        // TODO add your handling code here:
        System.out.println(evt.getActionCommand());
        if(evt.getActionCommand().equals("ApproveSelection"))
        	processXMLFile((File)jFileChooser1.getSelectedFile());
        if(evt.getActionCommand().equals("CancelSelection"))
            this.dispose();       
    }//GEN-LAST:event_jFileChooser1ActionPerformed
    
    private void processXMLFile(File xmlFile) {
    	try {
    		compatibilityPassed = XMLUtils.xmlValidation(xmlFile);
    	} catch (Exception e) {;}
        filename = (xmlFile).getName();
        this.dispose();
        if (DEBUG) System.out.println("[DEBUG][DeploymentXMLLoader.jFileChooser1ActionPerformed()] - attempting to parseXMLFile: " + ((File)jFileChooser1.getSelectedFile()).getAbsolutePath());
        Placement placement = parseXMLFile(xmlFile);
        callbackManager.jXMLLoaderCompletes(filename, compatibilityPassed, placement);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JFileChooser jFileChooser1;
    // End of variables declaration//GEN-END:variables
    
    private Placement parseXMLFile(File xmlFilename) {
        LocationData locationData = (LocationData)XMLUtils.xmlParser("sidnet.models.deployment.models.xml", xmlFilename);
        return new XMLPlacement(locationData, fieldWidth, fieldLength);
    }
}

@XmlRootElement(name="deployment")
class LocationData implements JistAPI.DoNotRewrite {
    public LocationData(){}
    
    @XmlElement(name="node")
    public List<Loc> nodesList;
    
    public static class Loc {
        @XmlElement(name="x")
        Float x;
        
        @XmlElement(name="y")
        Float y;
    }
}

