/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.metrics;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Stack;

public abstract class AbstractComplexityCheck
extends Check {
    private static final int INITIAL_VALUE = 1;
    private final Stack mValueStack = new Stack();
    private int mCurrentValue;
    private int mMax;

    public AbstractComplexityCheck(int aMax) {
        this.mMax = aMax;
    }

    protected abstract String getMessageID();

    protected void visitTokenHook(DetailAST aAST) {
    }

    protected void leaveTokenHook(DetailAST aAST) {
    }

    public final int[] getRequiredTokens() {
        return new int[]{8, 9, 11, 12};
    }

    public final int getMax() {
        return this.mMax;
    }

    public final void setMax(int aMax) {
        this.mMax = aMax;
    }

    public final void visitToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                this.visitMethodDef();
                break;
            }
            default: {
                this.visitTokenHook(aAST);
            }
        }
    }

    public final void leaveToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                this.leaveMethodDef(aAST);
                break;
            }
            default: {
                this.leaveTokenHook(aAST);
            }
        }
    }

    protected final int getCurrentValue() {
        return this.mCurrentValue;
    }

    protected final void setCurrentValue(int aValue) {
        this.mCurrentValue = aValue;
    }

    protected final void incrementCurrentValue(int aBy) {
        this.setCurrentValue(this.getCurrentValue() + aBy);
    }

    protected final void pushValue() {
        this.mValueStack.push(new Integer(this.mCurrentValue));
        this.mCurrentValue = 1;
    }

    protected final int popValue() {
        this.mCurrentValue = (Integer)this.mValueStack.pop();
        return this.mCurrentValue;
    }

    private void visitMethodDef() {
        this.pushValue();
    }

    private void leaveMethodDef(DetailAST aAST) {
        if (this.mCurrentValue > this.mMax) {
            this.log(aAST.getLineNo(), aAST.getColumnNo(), this.getMessageID(), new Integer(this.mCurrentValue), new Integer(this.mMax));
        }
        this.popValue();
    }
}

