/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.AbstractTypeAwareCheck;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.regexp.RE;

public class JavadocMethodCheck
extends AbstractTypeAwareCheck {
    private static final String MATCH_JAVADOC_ARG_PAT = "@(throws|exception|param)\\s+(\\S+)\\s+\\S";
    private static final RE MATCH_JAVADOC_ARG = Utils.createRE("@(throws|exception|param)\\s+(\\S+)\\s+\\S");
    private static final String MATCH_JAVADOC_ARG_MULTILINE_START_PAT = "@(throws|exception|param)\\s+(\\S+)\\s*$";
    private static final RE MATCH_JAVADOC_ARG_MULTILINE_START = Utils.createRE("@(throws|exception|param)\\s+(\\S+)\\s*$");
    private static final String MATCH_JAVADOC_MULTILINE_CONT_PAT = "(\\*/|@|[^\\s\\*])";
    private static final RE MATCH_JAVADOC_MULTILINE_CONT = Utils.createRE("(\\*/|@|[^\\s\\*])");
    private static final String END_JAVADOC = "*/";
    private static final String NEXT_TAG = "@";
    private static final String MATCH_JAVADOC_NOARG_PAT = "@(return|see)\\s+\\S";
    private static final RE MATCH_JAVADOC_NOARG = Utils.createRE("@(return|see)\\s+\\S");
    private static final String MATCH_JAVADOC_NOARG_MULTILINE_START_PAT = "@(return|see)\\s*$";
    private static final RE MATCH_JAVADOC_NOARG_MULTILINE_START = Utils.createRE("@(return|see)\\s*$");
    private static final String MATCH_JAVADOC_NOARG_CURLY_PAT = "\\{\\s*@(inheritDoc)\\s*\\}";
    private static final RE MATCH_JAVADOC_NOARG_CURLY = Utils.createRE("\\{\\s*@(inheritDoc)\\s*\\}");
    private Scope mScope = Scope.PRIVATE;
    private boolean mAllowUndeclaredRTE;
    private boolean mAllowThrowsTagsForSubclasses;
    private boolean mAllowMissingParamTags;
    private boolean mAllowMissingThrowsTags;
    private boolean mAllowMissingReturnTag;

    public void setScope(String aFrom) {
        this.mScope = Scope.getInstance(aFrom);
    }

    public void setAllowUndeclaredRTE(boolean aFlag) {
        this.mAllowUndeclaredRTE = aFlag;
    }

    public void setAllowThrowsTagsForSubclasses(boolean aFlag) {
        this.mAllowThrowsTagsForSubclasses = aFlag;
    }

    public void setAllowMissingParamTags(boolean aFlag) {
        this.mAllowMissingParamTags = aFlag;
    }

    public void setAllowMissingThrowsTags(boolean aFlag) {
        this.mAllowMissingThrowsTags = aFlag;
    }

    public void setAllowMissingReturnTag(boolean aFlag) {
        this.mAllowMissingReturnTag = aFlag;
    }

    public int[] getDefaultTokens() {
        return new int[]{16, 30, 9, 8};
    }

    public int[] getAcceptableTokens() {
        return new int[]{9, 8};
    }

    public int[] getRequiredTokens() {
        return new int[]{16, 30};
    }

    protected final void processAST(DetailAST aAST) {
        Scope surroundingScope;
        Scope targetScope;
        DetailAST mods = aAST.findFirstToken(5);
        Scope declaredScope = ScopeUtils.getScopeFromMods(mods);
        Scope scope = targetScope = ScopeUtils.inInterfaceBlock(aAST) ? Scope.PUBLIC : declaredScope;
        if (targetScope.isIn(this.mScope) && (surroundingScope = ScopeUtils.getSurroundingScope(aAST)).isIn(this.mScope)) {
            FileContents contents = this.getFileContents();
            TextBlock cmt = contents.getJavadocBefore(aAST.getLineNo());
            if (cmt == null) {
                this.log(aAST.getLineNo(), aAST.getColumnNo(), "javadoc.missing");
            } else {
                this.checkComment(aAST, cmt);
            }
        }
    }

    private void checkComment(DetailAST aAST, TextBlock aComment) {
        List tags = this.getMethodTags(aComment);
        if (tags.size() == 1 && ((JavadocTag)tags.get(0)).isSeeOrInheritDocTag()) {
            return;
        }
        boolean hasInheritDocTag = false;
        Iterator it = tags.iterator();
        while (it.hasNext() && !hasInheritDocTag) {
            hasInheritDocTag |= ((JavadocTag)it.next()).isInheritDocTag();
        }
        this.checkParamTags(tags, this.getParameters(aAST), !hasInheritDocTag);
        this.checkThrowsTags(tags, this.getThrows(aAST), !hasInheritDocTag);
        if (this.isFunction(aAST)) {
            this.checkReturnTag(tags, aAST.getLineNo(), !hasInheritDocTag);
        }
        it = tags.iterator();
        while (it.hasNext()) {
            JavadocTag jt = (JavadocTag)it.next();
            if (jt.isSeeOrInheritDocTag()) continue;
            this.log(jt.getLineNo(), "javadoc.unusedTagGeneral");
        }
    }

    private List getMethodTags(TextBlock aComment) {
        String[] lines = aComment.getText();
        ArrayList<JavadocTag> tags = new ArrayList<JavadocTag>();
        int currentLine = aComment.getStartLineNo() - 1;
        int i = 0;
        while (i < lines.length) {
            String p1;
            ++currentLine;
            if (MATCH_JAVADOC_ARG.match(lines[i])) {
                tags.add(new JavadocTag(currentLine, MATCH_JAVADOC_ARG.getParen(1), MATCH_JAVADOC_ARG.getParen(2)));
            } else if (MATCH_JAVADOC_NOARG.match(lines[i])) {
                tags.add(new JavadocTag(currentLine, MATCH_JAVADOC_NOARG.getParen(1)));
            } else if (MATCH_JAVADOC_NOARG_CURLY.match(lines[i])) {
                tags.add(new JavadocTag(currentLine, MATCH_JAVADOC_NOARG_CURLY.getParen(1)));
            } else if (MATCH_JAVADOC_ARG_MULTILINE_START.match(lines[i])) {
                p1 = MATCH_JAVADOC_ARG_MULTILINE_START.getParen(1);
                String p2 = MATCH_JAVADOC_ARG_MULTILINE_START.getParen(2);
                int remIndex = i + 1;
                while (remIndex < lines.length) {
                    if (MATCH_JAVADOC_MULTILINE_CONT.match(lines[remIndex])) {
                        remIndex = lines.length;
                        String lFin = MATCH_JAVADOC_MULTILINE_CONT.getParen(1);
                        if (!lFin.equals(NEXT_TAG) && !lFin.equals(END_JAVADOC)) {
                            tags.add(new JavadocTag(currentLine, p1, p2));
                        }
                    }
                    ++remIndex;
                }
            } else if (MATCH_JAVADOC_NOARG_MULTILINE_START.match(lines[i])) {
                p1 = MATCH_JAVADOC_NOARG_MULTILINE_START.getParen(1);
                int remIndex = i + 1;
                while (remIndex < lines.length) {
                    if (MATCH_JAVADOC_MULTILINE_CONT.match(lines[remIndex])) {
                        remIndex = lines.length;
                        String lFin = MATCH_JAVADOC_MULTILINE_CONT.getParen(1);
                        if (!lFin.equals(NEXT_TAG) && !lFin.equals(END_JAVADOC)) {
                            tags.add(new JavadocTag(currentLine, p1));
                        }
                    }
                    ++remIndex;
                }
            }
            ++i;
        }
        return tags;
    }

    private List getParameters(DetailAST aAST) {
        DetailAST params = aAST.findFirstToken(20);
        ArrayList<DetailAST> retVal = new ArrayList<DetailAST>();
        DetailAST child = (DetailAST)params.getFirstChild();
        while (child != null) {
            if (child.getType() == 21) {
                DetailAST ident = child.findFirstToken(58);
                retVal.add(ident);
            }
            child = (DetailAST)child.getNextSibling();
        }
        return retVal;
    }

    private List getThrows(DetailAST aAST) {
        ArrayList<ExceptionInfo> retVal = new ArrayList<ExceptionInfo>();
        DetailAST throwsAST = aAST.findFirstToken(81);
        if (throwsAST != null) {
            DetailAST child = (DetailAST)throwsAST.getFirstChild();
            while (child != null) {
                if (child.getType() == 58 || child.getType() == 59) {
                    ExceptionInfo ei = new ExceptionInfo(FullIdent.createFullIdent(child));
                    retVal.add(ei);
                }
                child = (DetailAST)child.getNextSibling();
            }
        }
        return retVal;
    }

    private void checkParamTags(List aTags, List aParams, boolean aReportExpectedTags) {
        ListIterator tagIt = aTags.listIterator();
        while (tagIt.hasNext()) {
            JavadocTag tag = (JavadocTag)tagIt.next();
            if (!tag.isParamTag()) continue;
            tagIt.remove();
            boolean found = false;
            Iterator paramIt = aParams.iterator();
            while (paramIt.hasNext()) {
                DetailAST param = (DetailAST)paramIt.next();
                if (!param.getText().equals(tag.getArg1())) continue;
                found = true;
                paramIt.remove();
                break;
            }
            if (found) continue;
            this.log(tag.getLineNo(), "javadoc.unusedTag", (Object)"@param", (Object)tag.getArg1());
        }
        if (!this.mAllowMissingParamTags && aReportExpectedTags) {
            Iterator paramIt = aParams.iterator();
            while (paramIt.hasNext()) {
                DetailAST param = (DetailAST)paramIt.next();
                this.log(param.getLineNo(), param.getColumnNo(), "javadoc.expectedTag", "@param", param.getText());
            }
        }
    }

    private boolean isFunction(DetailAST aAST) {
        DetailAST typeAST;
        boolean retVal = false;
        if (aAST.getType() == 9 && (typeAST = aAST.findFirstToken(13)) != null && typeAST.findFirstToken(49) == null) {
            retVal = true;
        }
        return retVal;
    }

    private void checkReturnTag(List aTags, int aLineNo, boolean aReportExpectedTags) {
        boolean found = false;
        ListIterator it = aTags.listIterator();
        while (it.hasNext()) {
            JavadocTag jt = (JavadocTag)it.next();
            if (!jt.isReturnTag()) continue;
            if (found) {
                this.log(jt.getLineNo(), "javadoc.return.duplicate");
            }
            found = true;
            it.remove();
        }
        if (!found && !this.mAllowMissingReturnTag && aReportExpectedTags) {
            this.log(aLineNo, "javadoc.return.expected");
        }
    }

    private void checkThrowsTags(List aTags, List aThrows, boolean aReportExpectedTags) {
        HashSet<String> foundThrows = new HashSet<String>();
        ListIterator tagIt = aTags.listIterator();
        while (tagIt.hasNext()) {
            JavadocTag tag = (JavadocTag)tagIt.next();
            if (!tag.isThrowsTag()) continue;
            tagIt.remove();
            String documentedEx = tag.getArg1();
            boolean found = foundThrows.contains(documentedEx);
            Class documentedClass = null;
            boolean classLoaded = false;
            ListIterator throwIt = aThrows.listIterator();
            while (!found && throwIt.hasNext()) {
                ExceptionInfo ei = (ExceptionInfo)throwIt.next();
                FullIdent fi = ei.getName();
                String declaredEx = fi.getText();
                if (this.isSameType(declaredEx, documentedEx)) {
                    found = true;
                    ei.setFound();
                    foundThrows.add(documentedEx);
                    continue;
                }
                if (!this.mAllowThrowsTagsForSubclasses) continue;
                if (!classLoaded) {
                    documentedClass = this.loadClassForTag(tag);
                    classLoaded = true;
                }
                found = this.isSubclass(documentedClass, ei.getClazz());
            }
            if (found) continue;
            boolean reqd = true;
            if (this.mAllowUndeclaredRTE) {
                if (!classLoaded) {
                    documentedClass = this.loadClassForTag(tag);
                    classLoaded = true;
                }
                boolean bl = reqd = !this.isUnchecked(documentedClass);
            }
            if (!reqd) continue;
            this.log(tag.getLineNo(), "javadoc.unusedTag", (Object)"@throws", (Object)tag.getArg1());
        }
        if (!this.mAllowMissingThrowsTags && aReportExpectedTags) {
            ListIterator throwIt = aThrows.listIterator();
            while (throwIt.hasNext()) {
                ExceptionInfo ei = (ExceptionInfo)throwIt.next();
                if (ei.isFound()) continue;
                FullIdent fi = ei.getName();
                this.log(fi.getLineNo(), fi.getColumnNo(), "javadoc.expectedTag", "@throws", fi.getText());
            }
        }
    }

    private Class loadClassForTag(JavadocTag aTag) {
        Class clazz = this.resolveClass(aTag.getArg1());
        if (clazz == null) {
            this.log(aTag.getLineNo(), "javadoc.classInfo", (Object)"@throws", (Object)aTag.getArg1());
        }
        return clazz;
    }

    protected final void logLoadError(FullIdent aIdent) {
        this.log(aIdent.getLineNo(), "javadoc.classInfo", (Object)"@throws", (Object)aIdent.getText());
    }

    class ExceptionInfo
    extends AbstractTypeAwareCheck.ClassInfo {
        private boolean mFound;

        ExceptionInfo(FullIdent aIdent) {
            super(aIdent);
        }

        final void setFound() {
            this.mFound = true;
        }

        final boolean isFound() {
            return this.mFound;
        }
    }
}

