/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import java.util.HashSet;
import java.util.Set;

public final class IllegalCatchCheck
extends Check {
    private final Set mIllegalClassNames = new HashSet();

    public IllegalCatchCheck() {
        this.setIllegalClassNames(new String[]{"Exception", "Error", "RuntimeException", "Throwable", "java.lang.Error", "java.lang.Exception", "java.lang.RuntimeException", "java.lang.Throwable"});
    }

    public int[] getDefaultTokens() {
        return new int[]{96};
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST aDetailAST) {
        DetailAST paramDef = aDetailAST.findFirstToken(21);
        DetailAST excType = paramDef.findFirstToken(13);
        FullIdent ident = CheckUtils.createFullType(excType);
        if (this.isIllegalClassName(ident.getText())) {
            this.log(aDetailAST.getLineNo(), aDetailAST.getColumnNo(), "illegal.catch", (Object)ident.getText());
        }
    }

    private boolean isIllegalClassName(String aIdent) {
        return this.mIllegalClassNames.contains(aIdent);
    }

    public void setIllegalClassNames(String[] aClassNames) {
        this.mIllegalClassNames.clear();
        int i = 0;
        while (i < aClassNames.length) {
            String name = aClassNames[i];
            this.mIllegalClassNames.add(name);
            int lastDot = name.lastIndexOf(".");
            if (lastDot > 0 && lastDot < name.length() - 1) {
                String shortName = name.substring(name.lastIndexOf(".") + 1);
                this.mIllegalClassNames.add(shortName);
            }
            ++i;
        }
    }
}

