/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;

public class ExplicitInitializationCheck
extends Check {
    public final int[] getDefaultTokens() {
        return new int[]{10};
    }

    public final int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST aAST) {
        int primitiveType;
        if (ScopeUtils.isLocalVariableDef(aAST)) {
            return;
        }
        DetailAST assign = aAST.findFirstToken(80);
        if (assign == null) {
            return;
        }
        DetailAST modifiers = aAST.findFirstToken(5);
        if (modifiers != null && modifiers.branchContains(39)) {
            return;
        }
        DetailAST type = aAST.findFirstToken(13);
        DetailAST ident = aAST.findFirstToken(58);
        DetailAST exprStart = (DetailAST)assign.getFirstChild().getFirstChild();
        if (this.isObjectType(type) && exprStart.getType() == 135) {
            this.log(ident.getLineNo(), ident.getColumnNo(), "explicit.init", ident.getText(), "null");
        }
        if ((primitiveType = type.getFirstChild().getType()) == 50 && exprStart.getType() == 134) {
            this.log(ident.getLineNo(), ident.getColumnNo(), "explicit.init", ident.getText(), "false");
        }
        if (this.isNumericType(primitiveType) && this.isZero(exprStart)) {
            this.log(ident.getLineNo(), ident.getColumnNo(), "explicit.init", ident.getText(), "0");
        }
        if (primitiveType == 52 && (this.isZero(exprStart) || exprStart.getType() == 138 && "'\\0'".equals(exprStart.getText()))) {
            this.log(ident.getLineNo(), ident.getColumnNo(), "explicit.init", ident.getText(), "\\0");
        }
    }

    private boolean isObjectType(DetailAST aType) {
        int type = aType.getFirstChild().getType();
        return type == 58 || type == 59 || type == 17;
    }

    private boolean isNumericType(int aType) {
        return aType == 51 || aType == 53 || aType == 54 || aType == 55 || aType == 56 || aType == 57;
    }

    private boolean isZero(DetailAST aExpr) {
        int type = aExpr.getType();
        switch (type) {
            case 137: 
            case 140: 
            case 141: 
            case 142: {
                String text = aExpr.getText();
                return 0.0f == CheckUtils.parseFloat(text, type);
            }
        }
        return false;
    }
}

