/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import java.util.Stack;

public class DeclarationOrderCheck
extends Check {
    private static final int STATE_STATIC_VARIABLE_DEF = 1;
    private static final int STATE_INSTANCE_VARIABLE_DEF = 2;
    private static final int STATE_CTOR_DEF = 3;
    private static final int STATE_METHOD_DEF = 4;
    private Stack mScopeStates = new Stack();

    public int[] getDefaultTokens() {
        return new int[]{8, 9, 5, 6};
    }

    public void visitToken(DetailAST aAST) {
        int parentType = aAST.getParent().getType();
        switch (aAST.getType()) {
            case 6: {
                this.mScopeStates.push(new ScopeState());
                break;
            }
            case 8: {
                if (parentType != 6) {
                    return;
                }
                ScopeState state = (ScopeState)this.mScopeStates.peek();
                if (state.mScopeState > 3) {
                    this.log(aAST, "declaration.order.constructor");
                    break;
                }
                state.mScopeState = 3;
                break;
            }
            case 9: {
                ScopeState state = (ScopeState)this.mScopeStates.peek();
                if (parentType != 6) {
                    return;
                }
                if (state.mScopeState > 4) {
                    this.log(aAST, "declaration.order.method");
                    break;
                }
                state.mScopeState = 4;
                break;
            }
            case 5: {
                if (parentType != 10 || aAST.getParent().getParent().getType() != 6) {
                    return;
                }
                ScopeState state = (ScopeState)this.mScopeStates.peek();
                if (aAST.findFirstToken(64) != null) {
                    if (state.mScopeState > 1) {
                        this.log(aAST, "declaration.order.static");
                    } else {
                        state.mScopeState = 1;
                    }
                } else if (state.mScopeState > 2) {
                    this.log(aAST, "declaration.order.instance");
                } else if (state.mScopeState == 1) {
                    state.mDeclarationAccess = Scope.PUBLIC;
                    state.mScopeState = 2;
                }
                Scope access = ScopeUtils.getScopeFromMods(aAST);
                if (state.mDeclarationAccess.compareTo(access) > 0) {
                    this.log(aAST, "declaration.order.access");
                    break;
                }
                state.mDeclarationAccess = access;
                break;
            }
        }
    }

    public void leaveToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 6: {
                this.mScopeStates.pop();
                break;
            }
        }
    }

    private void log(DetailAST aAST, String aError) {
        this.log(aAST.getLineNo(), aAST.getColumnNo(), aError);
    }

    private class ScopeState {
        private int mScopeState = 1;
        private Scope mDeclarationAccess = Scope.PUBLIC;

        private ScopeState() {
        }
    }
}

