/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;

public class DescendantTokenCheck
extends Check {
    private int mMinimumDepth;
    private int mMaximumDepth = Integer.MAX_VALUE;
    private int mMinimumNumber;
    private int mMaximumNumber = Integer.MAX_VALUE;
    private int[] mLimitedTokens = new int[0];
    private String mMinimumMessage = "descendant.token.min";
    private String mMaximumMessage = "descendant.token.max";
    private int[] mCounts = new int[0];

    public int[] getDefaultTokens() {
        return new int[0];
    }

    public void visitToken(DetailAST aAST) {
        Arrays.fill(this.mCounts, 0);
        this.countTokens(aAST, 0);
        String name = TokenTypes.getTokenName(aAST.getType());
        int i = 0;
        while (i < this.mLimitedTokens.length) {
            String descendantName;
            int tokenCount = this.mCounts[this.mLimitedTokens[i] - 1];
            if (tokenCount < this.mMinimumNumber) {
                descendantName = TokenTypes.getTokenName(this.mLimitedTokens[i]);
                this.log(aAST.getLineNo(), aAST.getColumnNo(), this.mMinimumMessage, new String[]{"" + tokenCount, "" + this.mMinimumNumber, name, descendantName});
            }
            if (tokenCount > this.mMaximumNumber) {
                descendantName = TokenTypes.getTokenName(this.mLimitedTokens[i]);
                this.log(aAST.getLineNo(), aAST.getColumnNo(), this.mMaximumMessage, new String[]{"" + tokenCount, "" + this.mMaximumNumber, name, descendantName});
            }
            ++i;
        }
    }

    private void countTokens(AST aAST, int aDepth) {
        if (aDepth <= this.mMaximumDepth) {
            int type;
            if (aDepth >= this.mMinimumDepth && (type = aAST.getType()) <= this.mCounts.length) {
                int n = type - 1;
                this.mCounts[n] = this.mCounts[n] + 1;
            }
            AST child = aAST.getFirstChild();
            int nextDepth = aDepth + 1;
            while (child != null) {
                this.countTokens(child, nextDepth);
                child = child.getNextSibling();
            }
        }
    }

    public int[] getAcceptableTokens() {
        Set tokenNames = this.getTokenNames();
        int[] result = new int[tokenNames.size()];
        int i = 0;
        Iterator it = tokenNames.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            result[i] = TokenTypes.getTokenId(name);
            ++i;
        }
        return result;
    }

    public void setLimitedTokens(String[] aLimitedTokens) {
        this.mLimitedTokens = new int[aLimitedTokens.length];
        int maxToken = 0;
        int i = 0;
        while (i < aLimitedTokens.length) {
            this.mLimitedTokens[i] = TokenTypes.getTokenId(aLimitedTokens[i]);
            if (this.mLimitedTokens[i] > maxToken) {
                maxToken = this.mLimitedTokens[i];
            }
            ++i;
        }
        this.mCounts = new int[maxToken];
    }

    public void setMinimumDepth(int aMinimumDepth) {
        this.mMinimumDepth = aMinimumDepth;
    }

    public void setMaximumDepth(int aMaximumDepth) {
        this.mMaximumDepth = aMaximumDepth;
    }

    public void setMinimumNumber(int aMinimumNumber) {
        this.mMinimumNumber = aMinimumNumber;
    }

    public void setMaximumNumber(int aMaximumNumber) {
        this.mMaximumNumber = aMaximumNumber;
    }

    public void setMinimumMessage(String aMessage) {
        this.mMinimumMessage = aMessage;
    }

    public void setMaximumMessage(String aMessage) {
        this.mMaximumMessage = aMessage;
    }
}

