/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import antlr.CommonAST;
import antlr.Token;
import antlr.collections.AST;
import java.util.BitSet;

public final class DetailAST
extends CommonAST {
    private static final int NOT_INITIALIZED = Integer.MIN_VALUE;
    private int mLineNo = Integer.MIN_VALUE;
    private int mColumnNo = Integer.MIN_VALUE;
    private int mChildCount = Integer.MIN_VALUE;
    private DetailAST mParent;
    private BitSet mBranchTokenTypes;

    public void initialize(Token aTok) {
        super.initialize(aTok);
        this.mLineNo = aTok.getLine();
        this.mColumnNo = aTok.getColumn() - 1;
    }

    public void initialize(AST aAST) {
        DetailAST da = (DetailAST)aAST;
        this.setText(da.getText());
        this.setType(da.getType());
        this.mLineNo = da.getLineNo();
        this.mColumnNo = da.getColumnNo();
    }

    public void setFirstChild(AST aAST) {
        this.mChildCount = Integer.MIN_VALUE;
        super.setFirstChild(aAST);
        if (aAST != null) {
            ((DetailAST)aAST).setParent(this);
        }
    }

    public void setNextSibling(AST aAST) {
        super.setNextSibling(aAST);
        if (aAST != null && this.mParent != null) {
            ((DetailAST)aAST).setParent(this.mParent);
        }
    }

    public void addChild(AST aAST) {
        super.addChild(aAST);
        if (aAST != null) {
            ((DetailAST)aAST).setParent(this);
        }
    }

    public int getChildCount() {
        if (this.mChildCount == Integer.MIN_VALUE) {
            this.mChildCount = 0;
            AST child = this.getFirstChild();
            while (child != null) {
                ++this.mChildCount;
                child = child.getNextSibling();
            }
        }
        return this.mChildCount;
    }

    void setParent(DetailAST aParent) {
        this.mParent = aParent;
        DetailAST nextSibling = (DetailAST)this.getNextSibling();
        if (nextSibling != null) {
            nextSibling.setParent(aParent);
        }
    }

    public DetailAST getParent() {
        return this.mParent;
    }

    public int getLineNo() {
        if (this.mLineNo == Integer.MIN_VALUE) {
            DetailAST child = (DetailAST)this.getFirstChild();
            DetailAST sibling = (DetailAST)this.getNextSibling();
            if (child != null) {
                return child.getLineNo();
            }
            if (sibling != null) {
                return sibling.getLineNo();
            }
        }
        return this.mLineNo;
    }

    public int getColumnNo() {
        if (this.mColumnNo == Integer.MIN_VALUE) {
            DetailAST child = (DetailAST)this.getFirstChild();
            DetailAST sibling = (DetailAST)this.getNextSibling();
            if (child != null) {
                return child.getColumnNo();
            }
            if (sibling != null) {
                return sibling.getColumnNo();
            }
        }
        return this.mColumnNo;
    }

    public DetailAST getLastChild() {
        AST ast = this.getFirstChild();
        while (ast != null && ast.getNextSibling() != null) {
            ast = ast.getNextSibling();
        }
        return (DetailAST)ast;
    }

    private BitSet getBranchTokenTypes() {
        if (this.mBranchTokenTypes == null) {
            this.mBranchTokenTypes = new BitSet();
            this.mBranchTokenTypes.set(this.getType());
            DetailAST child = (DetailAST)this.getFirstChild();
            while (child != null) {
                BitSet childTypes = child.getBranchTokenTypes();
                this.mBranchTokenTypes.or(childTypes);
                child = (DetailAST)child.getNextSibling();
            }
        }
        return this.mBranchTokenTypes;
    }

    public boolean branchContains(int aType) {
        return this.getBranchTokenTypes().get(aType);
    }

    public int getChildCount(int aType) {
        int count = 0;
        AST i = this.getFirstChild();
        while (i != null) {
            if (i.getType() == aType) {
                ++count;
            }
            i = i.getNextSibling();
        }
        return count;
    }

    public DetailAST getPreviousSibling() {
        DetailAST parent = this.getParent();
        if (parent == null) {
            return null;
        }
        AST ast = parent.getFirstChild();
        while (ast != null) {
            AST nextSibling = ast.getNextSibling();
            if (this == nextSibling) {
                return (DetailAST)ast;
            }
            ast = nextSibling;
        }
        return null;
    }

    public DetailAST findFirstToken(int aType) {
        DetailAST retVal = null;
        AST i = this.getFirstChild();
        while (i != null) {
            if (i.getType() == aType) {
                retVal = (DetailAST)i;
                break;
            }
            i = i.getNextSibling();
        }
        return retVal;
    }
}

