/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.AbstractViolationReporter;
import com.puppycrawl.tools.checkstyle.api.FileSetCheck;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessages;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import java.io.File;
import java.util.ArrayList;

public abstract class AbstractFileSetCheck
extends AbstractViolationReporter
implements FileSetCheck {
    private MessageDispatcher mDispatcher;
    private String[] mFileExtensions = new String[0];
    private final LocalizedMessages mMessages = new LocalizedMessages();

    public void destroy() {
    }

    public final void setMessageDispatcher(MessageDispatcher aDispatcher) {
        this.mDispatcher = aDispatcher;
    }

    protected final MessageDispatcher getMessageDispatcher() {
        return this.mDispatcher;
    }

    protected final File[] filter(File[] aFiles) {
        if (this.mFileExtensions == null || this.mFileExtensions.length == 0) {
            return aFiles;
        }
        ArrayList<File> files = new ArrayList<File>(aFiles.length);
        int i = 0;
        while (i < aFiles.length) {
            File f = aFiles[i];
            String fileName = f.getName();
            int j = 0;
            while (j < this.mFileExtensions.length) {
                String fileExtension = this.mFileExtensions[j];
                if (fileName.endsWith(fileExtension)) {
                    files.add(f);
                }
                ++j;
            }
            ++i;
        }
        return files.toArray(new File[files.size()]);
    }

    public final void setFileExtensions(String[] aExtensions) {
        if (aExtensions == null) {
            this.mFileExtensions = null;
            return;
        }
        this.mFileExtensions = new String[aExtensions.length];
        int i = 0;
        while (i < aExtensions.length) {
            String extension = aExtensions[i];
            this.mFileExtensions[i] = extension.startsWith(".") ? extension : "." + extension;
            ++i;
        }
    }

    protected final LocalizedMessages getMessageCollector() {
        return this.mMessages;
    }

    protected final void log(int aLine, String aKey, Object[] aArgs) {
        this.log(aLine, 0, aKey, aArgs);
    }

    protected final void log(int aLineNo, int aColNo, String aKey, Object[] aArgs) {
        this.getMessageCollector().add(new LocalizedMessage(aLineNo, aColNo, this.getMessageBundle(), aKey, aArgs, this.getSeverityLevel(), this.getClass()));
    }

    protected final void fireErrors(String aFileName) {
        LocalizedMessage[] errors = this.getMessageCollector().getMessages();
        this.getMessageCollector().reset();
        this.getMessageDispatcher().fireErrors(aFileName, errors);
    }
}

