/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Stack;

public final class ExecutableStatementCountCheck
extends Check {
    private static final int DEFAULT_MAX = 30;
    private int mMax;
    private final Stack mContextStack = new Stack();
    private Context mContext;

    public ExecutableStatementCountCheck() {
        this.setMax(30);
    }

    public int[] getDefaultTokens() {
        return new int[]{8, 9, 11, 12, 7};
    }

    public int[] getRequiredTokens() {
        return new int[]{7};
    }

    public int getMax() {
        return this.mMax;
    }

    public void setMax(int aMax) {
        this.mMax = aMax;
    }

    public void beginTree(DetailAST aRootAST) {
        this.mContext = null;
        this.mContextStack.clear();
    }

    public void visitToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                this.visitMemberDef(aAST);
                break;
            }
            case 7: {
                this.visitSlist(aAST);
                break;
            }
            default: {
                throw new IllegalStateException(aAST.toString());
            }
        }
    }

    public void leaveToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                this.leaveMemberDef(aAST);
                break;
            }
            case 7: {
                break;
            }
            default: {
                throw new IllegalStateException(aAST.toString());
            }
        }
    }

    private void visitMemberDef(DetailAST aAST) {
        this.mContextStack.push(this.mContext);
        this.mContext = new Context(aAST);
    }

    private void leaveMemberDef(DetailAST aAST) {
        int count = this.mContext.getCount();
        if (count > this.getMax()) {
            this.log(aAST.getLineNo(), aAST.getColumnNo(), "executableStatementCount", new Integer(count), new Integer(this.getMax()));
        }
        this.mContext = (Context)this.mContextStack.pop();
    }

    private void visitSlist(DetailAST aAST) {
        if (this.mContext != null) {
            DetailAST contextAST = this.mContext.getAST();
            DetailAST parent = aAST.getParent();
            while (parent != null) {
                int type = parent.getType();
                if (type == 8 || type == 9 || type == 11 || type == 12) {
                    if (parent != contextAST) break;
                    this.mContext.addCount(aAST.getChildCount() / 2);
                    break;
                }
                parent = parent.getParent();
            }
        }
    }

    private class Context {
        private DetailAST mAST;
        private int mCount;

        public Context(DetailAST aAST) {
            this.mAST = aAST;
            this.mCount = 0;
        }

        public void addCount(int aCount) {
            this.mCount += aCount;
        }

        public DetailAST getAST() {
            return this.mAST;
        }

        public int getCount() {
            return this.mCount;
        }
    }
}

