/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.api.Utils;
import org.apache.commons.beanutils.ConversionException;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class JavadocTypeCheck
extends Check {
    private Scope mScope = Scope.PRIVATE;
    private RE mAuthorTagRE;
    private RE mAuthorFormatRE;
    private RE mVersionTagRE;
    private RE mVersionFormatRE;
    private String mAuthorFormat;
    private String mVersionFormat;

    public void setScope(String aFrom) {
        this.mScope = Scope.getInstance(aFrom);
    }

    public void setAuthorFormat(String aFormat) throws ConversionException {
        try {
            this.mAuthorTagRE = Utils.getRE("@author\\s+(.*$)");
            this.mAuthorFormat = aFormat;
            this.mAuthorFormatRE = Utils.getRE(aFormat);
        }
        catch (RESyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, e);
        }
    }

    public void setVersionFormat(String aFormat) throws ConversionException {
        try {
            this.mVersionTagRE = Utils.getRE("@version\\s+(.*$)");
            this.mVersionFormat = aFormat;
            this.mVersionFormatRE = Utils.getRE(aFormat);
        }
        catch (RESyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, e);
        }
    }

    public int[] getDefaultTokens() {
        return new int[]{15, 14};
    }

    public void visitToken(DetailAST aAST) {
        Scope surroundingScope;
        Scope typeScope;
        DetailAST mods = aAST.findFirstToken(5);
        Scope declaredScope = ScopeUtils.getScopeFromMods(mods);
        Scope scope = typeScope = ScopeUtils.inInterfaceBlock(aAST) ? Scope.PUBLIC : declaredScope;
        if (typeScope.isIn(this.mScope) && ((surroundingScope = ScopeUtils.getSurroundingScope(aAST)) == null || surroundingScope.isIn(this.mScope))) {
            int lineNo;
            FileContents contents = this.getFileContents();
            TextBlock cmt = contents.getJavadocBefore(lineNo = aAST.getLineNo());
            if (cmt == null) {
                this.log(lineNo, "javadoc.missing");
            } else if (ScopeUtils.isOuterMostType(aAST)) {
                this.checkTag(lineNo, cmt.getText(), "@author", this.mAuthorTagRE, this.mAuthorFormatRE, this.mAuthorFormat);
                this.checkTag(lineNo, cmt.getText(), "@version", this.mVersionTagRE, this.mVersionFormatRE, this.mVersionFormat);
            }
        }
    }

    private void checkTag(int aLineNo, String[] aCmt, String aTag, RE aTagRE, RE aFormatRE, String aFormat) {
        if (aTagRE == null) {
            return;
        }
        int tagCount = 0;
        int i = 0;
        while (i < aCmt.length) {
            String s = aCmt[i];
            if (aTagRE.match(s)) {
                ++tagCount;
                int contentStart = aTagRE.getParenStart(1);
                String content = s.substring(contentStart);
                if (!aFormatRE.match(content)) {
                    this.log(aLineNo, "type.tagFormat", (Object)aTag, (Object)aFormat);
                }
            }
            ++i;
        }
        if (tagCount == 0) {
            this.log(aLineNo, "type.missingTag", (Object)aTag);
        }
    }
}

