/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;

public class IllegalImportCheck
extends Check {
    private String[] mIllegalPkgs;

    public IllegalImportCheck() {
        this.setIllegalPkgs(new String[]{"sun"});
    }

    public void setIllegalPkgs(String[] aFrom) {
        this.mIllegalPkgs = aFrom;
    }

    public int[] getDefaultTokens() {
        return new int[]{30};
    }

    public void visitToken(DetailAST aAST) {
        FullIdent imp = FullIdent.createFullIdentBelow(aAST);
        if (this.isIllegalImport(imp.getText())) {
            this.log(aAST.getLineNo(), aAST.getColumnNo(), "import.illegal", (Object)imp.getText());
        }
    }

    private boolean isIllegalImport(String aImportText) {
        int i = 0;
        while (i < this.mIllegalPkgs.length) {
            if (aImportText.startsWith(this.mIllegalPkgs[i] + ".")) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

