/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;

public class AvoidStarImportCheck
extends Check {
    private String[] mExcludes = new String[0];

    public int[] getDefaultTokens() {
        return new int[]{30};
    }

    public void setExcludes(String[] aExcludes) {
        this.mExcludes = new String[aExcludes.length];
        int i = 0;
        while (i < aExcludes.length) {
            this.mExcludes[i] = aExcludes[i];
            if (!this.mExcludes[i].endsWith(".*")) {
                this.mExcludes[i] = this.mExcludes[i] + ".*";
            }
            ++i;
        }
    }

    public void visitToken(DetailAST aAST) {
        FullIdent name = FullIdent.createFullIdentBelow(aAST);
        if (name != null && name.getText().endsWith(".*")) {
            boolean exempt = false;
            int i = 0;
            while (i < this.mExcludes.length && !exempt) {
                if (name.getText().equals(this.mExcludes[i])) {
                    exempt = true;
                }
                ++i;
            }
            if (!exempt) {
                this.log(aAST.getLineNo(), "import.avoidStar", (Object)name.getText());
            }
        }
    }
}

