/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;

public final class CheckUtils {
    private static final int BASE_8 = 8;
    private static final int BASE_10 = 10;
    private static final int BASE_16 = 16;

    private CheckUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean isElseIf(DetailAST aAST) {
        DetailAST parentAST = aAST.getParent();
        return aAST.getType() == 83 && (CheckUtils.isElse(parentAST) || CheckUtils.isElseWithCurlyBraces(parentAST));
    }

    private static boolean isElse(DetailAST aAST) {
        return aAST.getType() == 92;
    }

    private static boolean isElseWithCurlyBraces(DetailAST aAST) {
        return aAST.getType() == 7 && aAST.getChildCount() == 2 && CheckUtils.isElse(aAST.getParent());
    }

    public static FullIdent createFullType(DetailAST aTypeAST) {
        DetailAST arrayDeclAST = aTypeAST.findFirstToken(17);
        return CheckUtils.createFullTypeNoArrays(arrayDeclAST == null ? aTypeAST : arrayDeclAST);
    }

    private static FullIdent createFullTypeNoArrays(DetailAST aTypeAST) {
        return FullIdent.createFullIdent((DetailAST)aTypeAST.getFirstChild());
    }

    public static float parseFloat(String aText, int aType) {
        float result = 0.0f;
        switch (aType) {
            case 140: 
            case 142: {
                result = (float)Double.parseDouble(aText);
                break;
            }
            case 137: 
            case 141: {
                int radix = 10;
                if (aText.startsWith("0x") || aText.startsWith("0X")) {
                    radix = 16;
                    aText = aText.substring(2);
                } else if (aText.charAt(0) == '0') {
                    radix = 8;
                    aText = aText.substring(1);
                }
                if (aText.endsWith("L") || aText.endsWith("l")) {
                    aText = aText.substring(0, aText.length() - 1);
                }
                if (aText.length() <= 0) break;
                result = Long.parseLong(aText, radix);
                break;
            }
        }
        return result;
    }
}

